__author__ = "Craig LaBarge WB3GCK"
__contact__ = "https://wb3gck.com/contact/"
__date__ = "5/03/2019"

# This script is used to add my custom tags to ADIFs exported from SKCCLogger or other programs.
# The script expects:
#     Files in ADIF located in the same working directory as the script
#     ADIF files must have a ".adi" or ".adif" extension.


import os
import sys


def listfiles():
    """This function finds all ADIF files in the working directory and prints out a listing with index
    numbers.  It returns a list of available ADIF files."""
    logs = []
    count = 1
    for filename in (os.listdir('.')):
        if '.adi' in filename:
            logs.append(filename)
            print(str(count) + ' - ' + filename)
            count = count + 1
    if not logs:   # Check for empty list; e.g., no PDFs found
        print('')
        print('Ooops! No ADIF files found!!  \nTerminating script...\n')
        sys.exit()
    else:
        print('')
        return logs


print('\n*** add_tags.py ' + __version__ + ' by WB3GCK ***\n')


# Prompt the user for the integer number corresponding to the desired message file.
# Check to make sure the input is within the proper range
good_file = False
file_choice = ''
file_list = listfiles()  # Get a list of ADIF files
file_in = ''
while not good_file:
    file_in = input('Enter the ADIF file number:  ')
    if not file_in.isdecimal():  # Check for non-numeric input
        print('Input must be a numeral!  Try again, Pal!')
        continue
    else:
        file_nr = int(file_in) - 1
    if file_nr < 0 or file_nr > (len(file_list) - 1):  # Check for out of range input
        print('Input out of range.  Better try that again, Bucko.')
    else:
        file_choice = file_list[file_nr]  # Sets the selected file name
        good_file = True

# Check the selected file for the presence of a TX_PWR tag
if ('TX_PWR' in open(file_choice).read()) or ('tx_pwr' in open(file_choice).read()):
    has_pwr = True
else:
    has_pwr = False

# Prompt user for the MY_QTH value
my_qth = input(r'Enter QTH:  ')
qth_tag = '<MY_QTH:' + str(len(my_qth)) + '>' + my_qth + ' '

# Prompt user for MY_RIG value
my_rig = input(r'Enter Rig:  ')
rig_tag = '<MY_RIG:' + str(len(my_rig)) + '>' + my_rig + ' '


# Prompt user for TX_PWR if there is no TX_PWR in the selected file
good_pwr = False
tx_pwr = ''
pwr_tag = ''
if not has_pwr:
    while not good_pwr:
        tx_pwr = input('Enter TX_PWR:  ')
        # Check for numerals and decimal points only
        try:
            val = float(tx_pwr)
            good_pwr = True
        except ValueError:
            print("Hey Bucko! Numerals and decimal points only!!")
    pwr_tag = '<TX_PWR:' + str(len(tx_pwr)) + '>' + tx_pwr + ' '

# Create the replacement tag
if not has_pwr:
    new_tags = qth_tag + rig_tag + pwr_tag + '<EOR>'
else:
    new_tags = qth_tag + rig_tag + '<EOR>'

# Modify the selected ADIF file
file = open(file_choice, 'r')
filedata = file.read()

# Replace the target string
if '<EOR>' in open(file_choice).read():
    filedata = filedata.replace('<EOR>', new_tags)
elif '<eor>' in open(file_choice).read():
    filedata = filedata.replace('<eor>', new_tags)
else:
    print('Are you sure this is a valid ADIF file?? \nTerminating script...')
    sys.exit()

file = open(file_choice, 'w')
file.write(filedata)

print('\nGreat success! ' + file_choice + ' modified.\n')
